<?php
App::uses('Component', 'Controller');
App::uses('HttpSocket', 'Network/Http');

class RecaptchaComponent extends Component
{
    public $Controller = null;
    public $error = null;

    public function verify($response = null, $ip = null)
    {
        $recaptcha_secretKey = Configure::read('Option.recaptcha_secretKey');
        if (empty($recaptcha_secretKey)) {
            throw new Exception(__("You must set your Recaptcha secret key!"));
        }

        $HttpSocket = new HttpSocket();

        $data = array(
            'secret' => Configure::read('Option.recaptcha_secretKey'),
            'response' => $response,
            //'remoteip' => $ip
        );

        $results = $HttpSocket->post('https://www.google.com/recaptcha/api/siteverify', $data);
        $response_data = json_decode($results->body, true);

        if ($response_data['success'] == false) {
            $recaptcha_error = '';
            foreach ($response_data['error-codes'] as $code) {
                $recaptcha_error .= $code . ' ';
            }

            $this->error = $recaptcha_error;
        }

        return $response_data['success'];
    }
}
